/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;
import net.salju.kobolds.KoboldsMod;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldWarriorEntity;
import net.salju.kobolds.init.KoboldsModEntities;
import net.salju.kobolds.init.KoboldsModSounds;

public class KoboldEntity
extends AbstractKoboldEntity {
    public KoboldEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<KoboldEntity>)((EntityType)KoboldsModEntities.KOBOLD.get()), world);
    }

    public KoboldEntity(EntityType<KoboldEntity> type, Level world) {
        super(type, world);
        this.m_21530_();
    }

    public static void init() {
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new KoboldTradeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new KoboldWarriorGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
    }

    class KoboldTradeGoal
    extends Goal {
        public final AbstractKoboldEntity kobold;

        public KoboldTradeGoal(AbstractKoboldEntity kobold) {
            this.kobold = kobold;
        }

        public boolean m_8036_() {
            return this.checkHand() && !this.kobold.m_21023_(MobEffects.f_19596_);
        }

        public void m_8056_() {
            this.kobold.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, -10, false, false));
            KoboldsMod.queueServerWork(100, () -> {
                this.kobold.m_21011_(InteractionHand.MAIN_HAND, true);
                this.kobold.m_5496_((SoundEvent)KoboldsModSounds.KOBOLD_TRADE.get(), 1.0f, 1.0f);
                Level world = this.kobold.f_19853_;
                double x = this.kobold.m_20185_();
                double y = this.kobold.m_20186_();
                double z = this.kobold.m_20189_();
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    lvl.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, new Vec3(x, y, z), Vec2.f_82462_, lvl, 4, "", (Component)Component.m_237113_((String)""), lvl.m_7654_(), null).m_81324_(), "/loot spawn ~ ~ ~ loot kobolds:gameplay/trader_loot");
                }
                KoboldsMod.queueServerWork(20, () -> this.kobold.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_));
            });
        }

        protected boolean checkHand() {
            return this.kobold.m_21206_().m_41720_() == Items.f_42616_;
        }
    }

    class KoboldWarriorGoal
    extends Goal {
        public final AbstractKoboldEntity kobold;

        public KoboldWarriorGoal(AbstractKoboldEntity kobold) {
            this.kobold = kobold;
        }

        public boolean m_8036_() {
            return this.checkHand() && !this.kobold.m_21023_(MobEffects.f_19596_);
        }

        public void m_8056_() {
            this.kobold.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, -10, false, false));
            KoboldsMod.queueServerWork(600, () -> {
                ItemStack weapon = this.kobold.m_21205_();
                ItemStack off = this.kobold.m_21206_();
                Level world = this.kobold.f_19853_;
                double x = this.kobold.m_20185_();
                double y = this.kobold.m_20186_();
                double z = this.kobold.m_20189_();
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    ItemEntity drop = new ItemEntity((Level)lvl, x, y, z, weapon);
                    drop.m_32010_(10);
                    world.m_7967_((Entity)drop);
                    this.kobold.m_8061_(EquipmentSlot.MAINHAND, off);
                    this.kobold.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
                    this.kobold.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
                    KoboldWarriorEntity war = (KoboldWarriorEntity)this.kobold.m_21406_((EntityType)KoboldsModEntities.KOBOLD_WARRIOR.get(), true);
                    ForgeEventFactory.onLivingConvert((LivingEntity)this.kobold, (LivingEntity)war);
                }
            });
        }

        protected boolean checkHand() {
            return this.kobold.m_21206_().m_41720_() instanceof AxeItem;
        }
    }
}

